VERSION 5.00
Begin VB.Form Clock 
   AutoRedraw      =   -1  'True
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   " PIC-Driven LED Clock"
   ClientHeight    =   3870
   ClientLeft      =   45
   ClientTop       =   315
   ClientWidth     =   3510
   BeginProperty Font 
      Name            =   "System"
      Size            =   9.75
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Clock.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   258
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   234
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame Clock_Frame 
      Caption         =   "Current Time"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3210
      Left            =   120
      TabIndex        =   1
      Top             =   45
      Width           =   3255
      Begin VB.Frame Frame1 
         Height          =   1525
         Left            =   120
         TabIndex        =   21
         Top             =   1560
         Width           =   3015
         Begin VB.CommandButton Comm_Link 
            Caption         =   "&ON"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   350
            Left            =   2160
            TabIndex        =   26
            ToolTipText     =   "Click to set hours from now"
            Top             =   1080
            Width           =   735
         End
         Begin VB.ComboBox Sel_Port 
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Left            =   1320
            TabIndex        =   24
            Top             =   1080
            Width           =   705
         End
         Begin VB.TextBox RX_Window 
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   735
            Left            =   120
            MultiLine       =   -1  'True
            ScrollBars      =   2  'Vertical
            TabIndex        =   22
            Top             =   240
            Width           =   2775
         End
         Begin VB.Image Picker_Img 
            Height          =   480
            Index           =   1
            Left            =   120
            Picture         =   "Clock.frx":030A
            Top             =   1005
            Width           =   480
         End
         Begin VB.Label Label1 
            Caption         =   "Comm:"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H8000000D&
            Height          =   255
            Index           =   2
            Left            =   720
            TabIndex        =   25
            Top             =   1125
            Width           =   555
         End
         Begin VB.Label Label1 
            Caption         =   "RX"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H8000000D&
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   23
            Top             =   0
            Width           =   315
         End
      End
      Begin VB.OptionButton Time_Format 
         Caption         =   "12Hr"
         BeginProperty Font 
            Name            =   "Microsoft Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   2525
         TabIndex        =   17
         ToolTipText     =   "12Hr Format"
         Top             =   540
         Width           =   675
      End
      Begin VB.OptionButton Time_Format 
         Caption         =   "24Hr"
         BeginProperty Font 
            Name            =   "Microsoft Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   2525
         TabIndex        =   16
         ToolTipText     =   "24Hr Format"
         Top             =   240
         Value           =   -1  'True
         Width           =   675
      End
      Begin VB.Frame Set_Time_Frame 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Left            =   120
         TabIndex        =   5
         Top             =   840
         Width           =   3015
         Begin VB.CommandButton Set_System_Time 
            Caption         =   "&Set"
            Enabled         =   0   'False
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   350
            Left            =   2160
            TabIndex        =   18
            ToolTipText     =   "Click to program new time to PIC"
            Top             =   215
            Width           =   735
         End
         Begin VB.TextBox Sel_Time_Input 
            Alignment       =   1  'Right Justify
            BorderStyle     =   0  'None
            BeginProperty Font 
               Name            =   "Microsoft Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   210
            Index           =   3
            Left            =   1485
            TabIndex        =   6
            Text            =   "AM"
            Top             =   285
            Width           =   255
         End
         Begin VB.PictureBox Picture1 
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BorderStyle     =   0  'None
            ForeColor       =   &H80000008&
            Height          =   250
            Left            =   600
            ScaleHeight     =   255
            ScaleWidth      =   885
            TabIndex        =   7
            Top             =   240
            Width           =   885
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   2
               Left            =   590
               MaxLength       =   2
               TabIndex        =   10
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   1
               Left            =   310
               MaxLength       =   2
               TabIndex        =   9
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   0
               Left            =   40
               MaxLength       =   2
               TabIndex        =   8
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.Label Label2 
               BackStyle       =   0  'Transparent
               Caption         =   ":"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   0
               Left            =   540
               TabIndex        =   12
               Top             =   25
               Width           =   135
            End
            Begin VB.Label Label2 
               BackStyle       =   0  'Transparent
               Caption         =   ":"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   1
               Left            =   240
               TabIndex        =   11
               Top             =   30
               Width           =   135
            End
         End
         Begin VB.TextBox Text1 
            BeginProperty Font 
               Name            =   "Microsoft Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   0
            Left            =   585
            TabIndex        =   14
            ToolTipText     =   "Selected Time"
            Top             =   225
            Width           =   1200
         End
         Begin VB.VScrollBar Adj_Sel_Time 
            Height          =   315
            Left            =   1800
            Max             =   -1
            Min             =   60
            TabIndex        =   13
            Top             =   225
            Value           =   60
            Width           =   255
         End
         Begin VB.Image Picker_Img 
            Height          =   480
            Index           =   0
            Left            =   50
            Picture         =   "Clock.frx":0614
            Top             =   120
            Width           =   480
         End
         Begin VB.Label Label1 
            Caption         =   "Set Time"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H8000000D&
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   15
            Top             =   0
            Width           =   675
         End
      End
      Begin VB.PictureBox Show_LED_Clock 
         Appearance      =   0  'Flat
         AutoRedraw      =   -1  'True
         BackColor       =   &H00000000&
         FillStyle       =   0  'Solid
         ForeColor       =   &H80000008&
         Height          =   465
         Left            =   150
         ScaleHeight     =   29
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   140
         TabIndex        =   4
         Top             =   295
         Width           =   2125
      End
      Begin VB.Line Line1 
         BorderWidth     =   2
         X1              =   140
         X2              =   2275
         Y1              =   290
         Y2              =   290
      End
      Begin VB.Shape Shape1 
         Height          =   555
         Left            =   120
         Top             =   240
         Width           =   2190
      End
   End
   Begin VB.CommandButton Simplified_UI 
      Caption         =   "<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   350
      Left            =   3150
      TabIndex        =   19
      ToolTipText     =   "Click to Simplify Interface"
      Top             =   3375
      Width           =   255
   End
   Begin VB.PictureBox SegDigits 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   450
      Left            =   120
      Picture         =   "Clock.frx":091E
      ScaleHeight     =   28
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   199
      TabIndex        =   3
      Top             =   360
      Visible         =   0   'False
      Width           =   3010
   End
   Begin VB.PictureBox Col 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   360
      Picture         =   "Clock.frx":5465
      ScaleHeight     =   17
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   5
      TabIndex        =   2
      Top             =   960
      Visible         =   0   'False
      Width           =   75
   End
   Begin VB.CommandButton OK 
      Caption         =   "&Close"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   350
      Left            =   1920
      TabIndex        =   0
      ToolTipText     =   "Close & Accept "
      Top             =   3375
      Width           =   1125
   End
   Begin VB.Label Label3 
      Caption         =   "2007 Trent Jackson"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   3480
      Width           =   1695
   End
   Begin VB.Menu mPopupSys 
      Caption         =   ""
      Visible         =   0   'False
   End
End
Attribute VB_Name = "Clock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

   '-----------------------------------------------------------------------------
   '~~~~  PIC Driven LED Clock By Trent Jackson 2006 All rights reserved  ~~~~~~
   '-----------------------------------------------------------------------------
   '                                                                            '
   '          Version: eta 0.1                                                 '
   '  Project started: 17/05/07                                                 '
   '         Finished: 17/05/07                                                 '                                                  '
   ' Bugs & Enquiries: trentjackson888@bigpond.com.au                           '
   '                                                                            '
   '-----------------------------------------------------------------------------

'APIs
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Private Declare Sub InitCommonControls Lib "comctl32.dll" ()

'Locals
Dim Time_AM_PM       As Boolean
Dim Setting_New_Time As Boolean
Dim Connected        As Boolean
Dim Set_Min          As String
Dim Set_Sec          As String
Dim Set_Hr           As String
Dim Set_Time_Str     As String
Dim strError         As String
Dim strData          As String
Dim intPortID        As Integer
Dim lngStatus        As Long
Dim lngSize          As Long

'BitBlt constants
Private Const DstInvert = &H550009
Private Const MergeCopy = &HC000CA
Private Const MergePaint = &HBB0226
Private Const NotSrcCopy = &H330008
Private Const NotSrcErase = (&H1100A6)
Private Const PatCopy = (&HF00021)
Private Const PatInvert = (&H5A0049)
Private Const PatPaint = (&HFB0A09)
Private Const SrcAnd = (&H8800C6)
Private Const SrcCopy = (&HCC0020)
Private Const SrcErase = (&H440328)
Private Const SrcInvert = (&H660046)
Private Const SrcPaint = (&HEE0086)

'Window consts
Private Const WM_CLOSE = &H10
Private Const HWND_BOTTOM = 1
Private Const HWND_NOTOPMOST = -2
Private Const HWND_TOP = 0
Private Const HWND_TOPMOST = -1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1

Private Sub Comm_Link_Click()
   
   Select Case Comm_Link.Caption
      Case "&ON"
           Connected = True
           Comm_Link.Caption = "&OFF"
           Set_System_Time.Enabled = True
           Call Poll_Comm_Port
      
      Case "&OFF"
           Connected = False
           Comm_Link.Caption = "&ON"
           Set_System_Time.Enabled = False
           Call CommClose(intPortID)
   End Select
End Sub

Private Sub Form_Initialize()
   
   '// Win XP styles used
   InitCommonControls
End Sub

Private Sub Form_Load()

    '// Init clock with starting defaults ...
    Clock.Show
    intPortID = 2
    Set_Time_Str = "00:00:00"
    Time_AM_PM = False
    
    Dim i As Long
    For i = 1 To 9
        Sel_Port.AddItem (i)
    Next
    
    Sel_Port.ListIndex = 1
    
    Call Blit_Clock(Set_Time_Str)
   
End Sub

Private Sub Sel_Port_Click()
   
   Call CommClose(intPortID)
   intPortID = Sel_Port.ListIndex + 1
End Sub

Private Sub Set_System_Time_Click()
   
   Dim i As Long
   
   For i = 0 To 2
      strData = "@" & Chr$(Mid$(Set_Time_Str, 1, 2)) & Chr$(Mid$(Set_Time_Str, 4, 2)) & Chr$(Mid$(Set_Time_Str, 7, 2))
      lngSize = Len(strData)
      lngStatus = CommWrite(intPortID, strData)
      Sleep 50
   Next

   If lngStatus <> lngSize Then
   ' Handle error.
   End If
End Sub

Public Sub Poll_Comm_Port()

    '// Init Comms ...
    lngStatus = CommOpen(intPortID, "COM" & CStr(intPortID), "baud=2400 parity=N data=8 stop=1")
    
    If lngStatus <> 0 Then
       lngStatus = CommGetError(strError)
       MsgBox "COM Error: " & strError
       Connected = False
       Comm_Link.Caption = "&ON"
    End If
        
    Do While Connected
      DoEvents
   '// Read maximum of 64 bytes from serial port.
      lngStatus = CommRead(intPortID, strData, 10)
      
   '// Refresh clock, check for valid sync byte first
      If lngStatus > 0 And Mid$(strData, 1, 1) = "@" Then ' Got sync ?
         RX_Window.Text = RX_Window.Text & strData        ' Add data received to RX window
         strData = Mid$(strData, 2, Len(strData))         ' Remove sync byte from time str
         
         Select Case Time_AM_PM                           ' Update LED clock
             Case False '24hr
                  Call Blit_Clock(strData)
          
             Case True  '12hr
                  Call Blit_Clock(Mid$(Format(strData, "hh:mm:ss AMPM"), 1, 8))
         End Select
      End If
   Loop
End Sub

Public Sub Blit_Clock(ByVal StrValue As String)
   
   Dim i As Long
   Dim e As Long
   Dim k As Long

   '//
   For i = Len(StrValue) To 1 Step -1
       k = k + 1                      'Inc digit count
       If k < 3 Then                  'Every 3rd chr is ":"
   
   '// Remove leading 0 from the first the hours if in 12hr mode
          If Mid$(StrValue, Len(StrValue) - i + 1, 1) = "0" And i = Len(StrValue) And Time_AM_PM Then
             BitBlt Show_LED_Clock.hDC, (Len(StrValue) * 20 - (i * 20)) - e, 0, 18, 26, SegDigits.hDC, 10 * 18, 0, SrcCopy
          Else
             BitBlt Show_LED_Clock.hDC, (Len(StrValue) * 20 - (i * 20)) - e, 0, 18, 26, SegDigits.hDC, Val(Mid$(StrValue, Len(StrValue) - i + 1, 1)) * 18, 0, SrcCopy
          End If
 
   '// Show ":" between digits
       Else
          k = 0
          e = e + 10                  'Reduce spacing for ":"
          BitBlt Show_LED_Clock.hDC, (Len(StrValue) * 20 - (i * 20)) - e + 12, 5, 18, 26, Col.hDC, 0, 0, SrcCopy
       End If

   Next
   Show_LED_Clock.Refresh             'Refresh w/ new contents
End Sub

Private Sub Sel_Time_Input_Click(Index As Integer)
   
   Dim i As Long

   '// Remove all selections in fields
   For i = 0 To 3
       Sel_Time_Input(i).SelLength = 0
   Next
   
   '// Sync current val with scroll bar
   If Val(Sel_Time_Input(Index).Text) < Adj_Sel_Time.Min Then
      Adj_Sel_Time.Value = Val(Sel_Time_Input(Index).Text)
   End If
      
   '// Highlight selection
   Sel_Time_Input(Index).SelStart = 0
   Sel_Time_Input(Index).SelLength = 2
   
   '// Enfore upper limit of adjustment w/ scroll bars
   Select Case Index
          Case 0
   '// Hrs
               Select Case Time_AM_PM
                      Case True
                           Adj_Sel_Time.Min = 13
                      Case False
                           Adj_Sel_Time.Min = 25
               End Select
   
   '// Secs & mins
          Case 1 To 2
               Adj_Sel_Time.Min = 60
   '//
          Case Else
               Adj_Sel_Time.Min = 2
   
   '// Sync w/ scroll bar
               Select Case Sel_Time_Input(3).Text
                      Case "AM"
                           Adj_Sel_Time.Value = 1
                      Case "PM"
                           Adj_Sel_Time.Value = 0
               End Select
   End Select
End Sub

Private Sub Adj_Sel_Time_Change()
   
   Dim i As Long
   Dim j As Long
   
   '// Find the active text field (hrs, mins sec or am / pm adj)
   For i = 0 To 3
       If Sel_Time_Input(i).SelText <> vbNullString Then 'Field selected?
          If i < 3 Then                                  'Num adj, sec, hr, mins
             j = Adj_Sel_Time.Value                      'Buff scroll bar val
          
   '// Hrs must be =>1 with 12hr operataion
             If Time_AM_PM And i = 0 And j < 1 Then j = 1
   
   '// Replace adjusted val back into text field
             Sel_Time_Input(i).Text = String(2 - Len(Trim(Str(j))), "0") & Trim(Str(j))
          '//
          Else                                           'AM / PM adj
          '//
             If Adj_Sel_Time.Value = 0 Then
                Sel_Time_Input(3).Text = "PM"
             Else
                Sel_Time_Input(3).Text = "AM"
             End If
          End If
          
   '// Return focus to text field & highlight all text
          Sel_Time_Input(i).SetFocus
          Sel_Time_Input(i).SelStart = 0
          Sel_Time_Input(i).SelLength = 2
       End If
   Next
   
   '// If scroll bar reaches upper limit then dec by 1 maintain focus
   If Adj_Sel_Time.Value = Adj_Sel_Time.Min Then
      Adj_Sel_Time.Value = Adj_Sel_Time.Value - 1
   
   '// Same story but w/ lower limit of the bar, hold at 0
   ElseIf Adj_Sel_Time.Value = Adj_Sel_Time.Max Then
      Adj_Sel_Time.Value = 0
   End If
   
   '// Refresh adj time
   Set_Hr = Sel_Time_Input(0).Text
   Set_Min = Sel_Time_Input(1).Text
   Set_Sec = Sel_Time_Input(2).Text
   
   '// Bulid full time return string in 24hr format regardless
   Set_Time_Str = Format(Set_Hr & ":" & Set_Min & ":" & Set_Sec & Space(0) & Sel_Time_Input(3).Text, "hh:mm:ss")
End Sub

Private Sub Sel_Time_Input_Change(Index As Integer)

   '// User may key in values too
   If Setting_New_Time Then Exit Sub
   
   '// Overflow check
   If Val(Sel_Time_Input(0)) > 12 And Time_AM_PM Then
      MsgBox "Maximum allowed hours is 12", vbOKOnly, "Can't Set Hours"
      Sel_Time_Input(0).Text = "12"
      Exit Sub
   
   '// Max hrs
   ElseIf Val(Sel_Time_Input(0)) > 23 Then
      MsgBox "Maximum allowed hours is 23", vbOKOnly, "Can't Set Hours"
      Sel_Time_Input(0).Text = "23"
      Exit Sub
   End If
   
   '// Mins
   If Val(Sel_Time_Input(1)) > 59 Then
      MsgBox "Maximum allowed minutes is 59", vbOKOnly, "Can't Set Minutes"
      Sel_Time_Input(1).Text = "59"
      Exit Sub
   End If
   
   '// Secs
   If Val(Sel_Time_Input(2)) > 59 Then
      MsgBox "Maximum allowed seconds is 59", vbOKOnly, "Can't Set seconds"
      Sel_Time_Input(2).Text = "59"
      Exit Sub
   End If
      
   '// Apply new val
   Adj_Sel_Time.Value = Val(Sel_Time_Input(Index).Text)
End Sub

Private Sub Sel_Time_Input_GotFocus(Index As Integer)
   
   '// Highlight selection when user tabs to field
   If Sel_Time_Input(Index).SelText = vbNullString Then
      Call Sel_Time_Input_Click(Index)
   End If
End Sub

Private Sub Sel_Time_Input_KeyPress(Index As Integer, KeyAscii As Integer)
   
   '// Ensure numerical values only
   If Not ((KeyAscii >= Asc("0") And KeyAscii <= Asc("9"))) Then
      If KeyAscii <> 8 Then                            'Allow backspace
         KeyAscii = 0                                  'Force to zero
      End If                                           '(Field  will not update)
   End If
End Sub

Private Sub Simplified_UI_Click()
   
   '// Simplify / extend UI
   Dim i As Long
   
   Select Case Simplified_UI.Caption
          Case "<"
                            Clock.Width = 2775
                           Clock.Height = 2000
                      Clock_Frame.Width = 162
                     Clock_Frame.Height = 64
                     Simplified_UI.Left = 154
                      Simplified_UI.Top = 75
                                OK.Left = 72
                                 OK.Top = 75
                 Set_Time_Frame.Visible = False
                  Simplified_UI.Caption = ">"
              Simplified_UI.ToolTipText = "Click to Expand"
               
   '// Restore to full sized UI
          Case ">"
                            Clock.Width = 3600
                           Clock.Height = 4230
                      Clock_Frame.Width = 217
                     Clock_Frame.Height = 214
                     Simplified_UI.Left = 210
                      Simplified_UI.Top = 225
                                OK.Left = 128
                                 OK.Top = 225
                 Set_Time_Frame.Visible = True
                  Simplified_UI.Caption = "<"
              Simplified_UI.ToolTipText = "Click to Simplify Interface"
   End Select
End Sub

Private Sub OK_Click()
   
   Unload Me
End Sub

Private Sub Form_Unload(Cancel As Integer)
   
   Connected = False
   Set Clock = Nothing
   Call CommClose(intPortID)
End Sub

Private Sub Time_Format_Click(Index As Integer)
   
   Time_AM_PM = Time_Format(1).Value
End Sub
